﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        public static double gDcIn = 0;
        public static double gVin = 0;         //input Voltage

        private void ShowDcInStatus()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC5;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get DC In Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                if (buf[4] == 0)    //unplug
                {
                    gDcIn = 0;
                    label13.Text = "Unplug";
                }
                else if (buf[4] == 1)    //plug-in
                {
                    gDcIn = 1;
                    label13.Text = "Plug-In";
                }
            }
        }

        private void ShowDcInVoltage()
        {
            byte res;
            byte[] buf = new byte[2];
            UInt16 d16;

            if (gLtc3350 == 1)
            {
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VIN, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Dc In Voltage Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    gVin = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    gVin = d16 * 0.00221; //unit 2.21mV -> V
                }

                label1.Text = gVin.ToString("0.00") + 'V';
            }
        }
    }
}
